//=============================================================================
// Tower mother class, never spawned (on purpose lol!!)
//=============================================================================
class Tower extends ScriptedPawn;

//Tower variables:
var Pawn	TowerOwner;
var Pawn	Enemy, MyTarget;
var int		TowerLevel;
var float	Ranges[5],
			TimerSpeed[5];				
var Weapon_Tower Master;
var sound FireSound;
var Class<Projectile> ProjectileType;
var bool bRunOnce;
var vector SetPoint;
var string TowerName;
var int	TowerNum;
var int TowerSellValue;
var Proj_Tower Base;

function Throw(Pawn Thrower, float force, vector StartPosition)
{
	local vector dir;

	dir = vector(TowerOwner.ViewRotation);
	dir.Z = dir.Z + 0.35 * (1 - Abs(dir.Z));
	Velocity = FMin(force,  Master.MaxTossForce) * Normal(dir);

	bBounce = true;
	DropFrom(StartPosition);
}

function DropFrom(vector StartLocation)
{
	if ( !SetLocation(StartLocation) )
		return; 

	SetPhysics(PHYS_Falling);
	GotoState('TacticalMove');
}

event Touch( Actor Other )
{

}

function CalculateTowerSellValue()
{
	//Check what tower it is and adjust sell value according to level, value = (puchase price + total upgrade price ) * 0.75
	if ( TowerName == "Ring of fire Tower" )
		{
		if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).RingOfFireLevel == 0 )
			TowerSellValue = 3000; //4000
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).RingOfFireLevel == 1 )
			TowerSellValue = 3940; //4000+1250
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).RingOfFireLevel == 2 )
			TowerSellValue = 5065; //4000+1250+1500
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).RingOfFireLevel == 3 )
			TowerSellValue = 6565; //4000+1250+1500+2000
		}
	else if ( TowerName == "Laser Cannon Tower" )
		{
		if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).LaserCannonLevel == 0 )
			TowerSellValue = 750; //1000
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).LaserCannonLevel == 1 )
			TowerSellValue = 1050; //1000+400
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).LaserCannonLevel == 2 )
			TowerSellValue = 1425; //1000+400+500
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).LaserCannonLevel == 3 )
			TowerSellValue = 1875; //1000+400+500+600
		}
	else if ( TowerName == "Krall Tower" )
		{
		if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).KrallLevel == 0 )
			TowerSellValue = 750; //1000
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).KrallLevel == 1 )
			TowerSellValue = 1125; //1000+500
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).KrallLevel == 2 )
			TowerSellValue = 1690; //1000+500+750
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).KrallLevel == 3 )
			TowerSellValue = 2440; //1000+500+750+1000
		}
	else if ( TowerName == "Nali Tower" )
		{
		if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).NaliLevel == 0 )
			TowerSellValue = 1500; //2000
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).NaliLevel == 1 )
			TowerSellValue = 2065; //2000+750
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).NaliLevel == 2 )
			TowerSellValue = 2625; //2000+750+750
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).NaliLevel == 3 )
			TowerSellValue = 3565; //2000+750+750+1250
		}
	else if ( TowerName == "Warlord Tower" )
		{
		if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).WarlordLevel == 0 )
			TowerSellValue = 3750; //5000
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).WarlordLevel == 1 )
			TowerSellValue = 4500; //5000+1000
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).WarlordLevel == 2 )
			TowerSellValue = 5625; //5000+1000+1500
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).WarlordLevel == 3 )
			TowerSellValue = 7125; //5000+1000+1500+2000
		}
	else if ( TowerName == "Slith Tower" )
		{
		if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).SlithLevel == 0 )
			TowerSellValue = 900; //1200
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).SlithLevel == 1 )
			TowerSellValue = 1275; //1200+500
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).SlithLevel == 2 )
			TowerSellValue = 1840; //1200+500+750
		else if ( PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo).SlithLevel == 3 )
			TowerSellValue = 2590; //1200+500+750+1000
		}
}

simulated function Tick(float DT) 
{
	Super.Tick(DT);
	if ( Health > 0 )
		{
		//Enemy = None;
		//OldEnemy = None;
		AttitudeToPlayer = ATTITUDE_Ignore;
		SetPHysics(PHYS_Flying);
		if (!IsInState('TacticalMove'))
			GotoState('TacticalMove');
		if ( MyTarget != None )
			ClientSetRotation(rotator(MyTarget.Location - Location));
		}
	if ( !bRunOnce )
		{
		SetTimer(TimerSpeed[TowerLevel],True);
		bRunOnce = True;
		log("Tower: Timer function initiated.");
		}
}

function damageAttitudeTo(pawn Other)
{
	AttitudeToPlayer = ATTITUDE_Ignore;
	GotoState('TacticalMove');
}

function eAttitude AttitudeTo(Pawn Other)
{
	AttitudeToPlayer = ATTITUDE_Ignore;
	GotoState('TacticalMove');
	Return AttitudeToPlayer;
}

function SpawnGibbedCarcass()
{
}

function Carcass SpawnCarcass()
{
}

function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
local UT_SpriteSmokePuff SP;

	if ( Damage > 0 )
		{
		SP = spawn(Class'UT_SpriteSmokePuff',,,HitLocation);
		SP.DrawScale = 0.5;
		}
}

function PlayDeathHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
}

//States:

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function Timer()
	{
	SetTimer(TimerSpeed[TowerLevel],True);
	FireAtEnemy();
	CalculateTowerSellValue();
	}

	function FireAtEnemy()
	{
	local Pawn P;
	local float ClosestOne;
	local Pawn Target;
	local float Range;

	Range = Ranges[TowerLevel];

	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
		if ( P.IsA('Balloon') )
			{
			if ( Vsize(P.Location - Location) < Range )
				{
				if ( Vsize(P.Location - Location) < ClosestOne || ClosestOne == 0 )
					{
					ClosestOne = Vsize(P.Location - Location);
					Target = P;
					}
				}
			}
		}
	if ( Target != None )
		{
		Shoot(Target);
		Enemy = Target;
		MyTarget = Target;
		}
	else
		MyTarget = None;
	}

	function Shoot(Pawn Target)
	{
	// This function is handled in the specific tower class
	}

	function SetFall()
	{
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType)
		{
		
		}

	function HitWall(vector HitNormal, actor Wall)
	{
	}

	function FearThisSpot(Actor aSpot)
	{
	}

	function AnimEnd() 
	{
	}

	function EnemyNotVisible()
	{
	}

	function bool ValidRecovery()
	{
	}
		
	function GiveUpTactical(bool bNoCharge)
	{	
	}		

/* PickDestination()
Choose a destination for the tactical move, based on aggressiveness and the tactical
situation. Make sure destination is reachable
*/
	function PickDestination(bool bNoCharge)
	{
	if ( Enemy != None )
		{
		//DesiredRotation = Rotator(Enemy.Location - Location);
		//Focus = Enemy.Location;
		Destination = SetPoint;
		}
	}

	function BeginState()
	{
	}
	
	function EndState()
	{
	}

//FIXME - what if bReadyToAttack at start
TacticalTick:
	Sleep(0.02);	
Begin:
	PickDestination(false);

DoMove:
	MoveTo(Destination);
	
NoCharge:

	if ( Enemy != None )
		{
		//DesiredRotation = Rotator(Enemy.Location - Location);
		//Focus = Enemy.Location;
		Destination = SetPoint;
		Goto('DoMove');
		}
	
AdjustFromWall:
	StrafeTo(Destination, Focus); 
	Destination = SetPoint; 
	Goto('DoMove');

TakeHit:
	Goto('DoMove');

RecoverEnemy:
	MoveTo(Destination);
	Goto('DoMove');
}

defaultproperties
{
	TowerLevel=1
	Ranges(1)=250
	Ranges(2)=350
	Ranges(3)=450
	Ranges(4)=550
	TimerSpeed(1)=1
	TimerSpeed(2)=0.9
	TimerSpeed(3)=0.8
	TimerSpeed(4)=0.7
	 DrawType=DT_Mesh
     AmbientGlow=64
     CollisionHeight=11.000000
	 bCollideActors=True
	 bCollideWorld=False
	 bBlockActors=False
	 bBlockPlayers=True
	 bProjTarget=True
	 bHidden=False
	 GroundSpeed=0.000000
	 AirSpeed=0.000000
     WaterSpeed=0.000000
     AccelRate=0.000000
}
